﻿using System;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace SharpTest
{
    public partial class Form1 : Form
    {
        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool Init(IntPtr Locale, int LocaleStringLength);

        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool Done();

        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern int Get_Last_Error(IntPtr errorString, ref int errorStringBufLen);

        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool Get_Version(IntPtr Version, ref int VersionStringBufLen);

        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool GetParametrs(IntPtr Xml, ref int XmlStringBufLen);

        //[DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        //private static extern bool SetParameter(IntPtr Name, int NameStringLength, IntPtr Value, int ValueStringLength);

        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool SetStringParameter(IntPtr Name, int NameStringLength, IntPtr Value, int ValueStringLength);

        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool SetIntParameter(IntPtr Name, int NameStringLength, int Value);

        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool Open(IntPtr DeviceId, ref int DeviceIdStringBufLen);

        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool Close(IntPtr DeviceId, int DeviceIdStringLength);

        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool DeviceTest(IntPtr Description, ref int DescriptionStringBufLen, IntPtr DemoModeDescription, ref int DemoModeDescriptionStringBufLen);
        
        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool GetAdditionalActions(IntPtr Xml, ref int XmlStringBufLen);

        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool DoAdditionalAction(IntPtr AdditionalActionName, int AdditionalActionNameStringLength);

        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool InitializePrinter(IntPtr DeviceId, int DeviceIdStringLength);

        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool PrintLabels(IntPtr DeviceId, int DeviceIdStringLength, IntPtr Xml, int XmlStringLength);

        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool OpenDesigner(IntPtr Xml, int XmlStringLength, IntPtr ImagesDpi, int ImagesDpiStringLength, IntPtr OutXml, ref int OutXmlStringBufLen);
       
        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool GetTemplatesList(IntPtr OutXml, ref int OutXmlStringBufLen);

        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool GetTemplates(IntPtr Xml, int XmlStringLength, IntPtr OutXml, ref int OutXmlStringBufLen);

        [DllImport("HexagonLabelPrinterDriver.dll", CallingConvention = CallingConvention.Cdecl)]
        private static extern bool SaveTemplate(IntPtr Xml, int XmlStringLength, IntPtr Name, int NameStringLength, IntPtr Email, int EmailStringLength, IntPtr Answer, ref int AnswerStringBufLen);

        public Form1()
        {
            InitializeComponent();
        }

        private void GetVersion_btn_Click(object sender, EventArgs e)
        {
            var Version = Marshal.AllocHGlobal(1024 * 1024);
            int l1 = 0;

            Get_Version(Version, ref l1);  
            richTextBox1.Clear();
            richTextBox1.AppendText("Version: " + Marshal.PtrToStringUni(Version));
  
            Marshal.FreeHGlobal(Version);
        }

        private void GetParametrs_btn_Click(object sender, EventArgs e)
        {
            var Xml = Marshal.AllocHGlobal(1024 * 1024);
            int l1 = 0;

            GetParametrs(Xml, ref l1);

            richTextBox1.Clear();
            richTextBox1.AppendText("Parametrs: " + Marshal.PtrToStringUni(Xml)); 

            Marshal.FreeHGlobal(Xml);  
        }

        private string GetError()
        {
            var error = Marshal.AllocHGlobal(1024 * 1024);
            int l1 = 0; 
            int errorCode = Get_Last_Error(error, ref l1); 
            string Error = Marshal.PtrToStringUni(error);
            Marshal.FreeHGlobal(error); 
            return Error + " (ErrorCode " + errorCode.ToString() + ")";
        }

        private void SetParametrs_btn_Click(object sender, EventArgs e)
        {
            richTextBox1.Clear();
            var Name = Marshal.StringToHGlobalAuto(label1.Text);
            var Value = Marshal.StringToHGlobalAuto(textBox1.Text);

            if (SetStringParameter(Name, label1.Text.Length, Value, textBox1.Text.Length))
                richTextBox1.AppendText("Parametr " + label1.Text + " set successful\r\n");
            else
                richTextBox1.AppendText(GetError());

            Marshal.FreeHGlobal(Name);
            Marshal.FreeHGlobal(Value);

            Name = Marshal.StringToHGlobalAuto(label2.Text);
            Value = Marshal.StringToHGlobalAuto(textBox2.Text);

            if (SetStringParameter(Name, label2.Text.Length, Value, textBox2.Text.Length))
                richTextBox1.AppendText("Parametr " + label2.Text + " set successful\r\n");
            else
                richTextBox1.AppendText(GetError());

            Marshal.FreeHGlobal(Name);
            Marshal.FreeHGlobal(Value);

            Name = Marshal.StringToHGlobalAuto(label3.Text);
            Value = Marshal.StringToHGlobalAuto(textBox3.Text);

            if (SetStringParameter(Name, label3.Text.Length, Value, textBox3.Text.Length))
                richTextBox1.AppendText("Parametr " + label3.Text + " set successful\r\n");
            else
                richTextBox1.AppendText(GetError());

            Marshal.FreeHGlobal(Name);
            Marshal.FreeHGlobal(Value);
        }

        private void Open_btn_Click(object sender, EventArgs e)
        {
            var DeviceId = Marshal.AllocHGlobal(1024 * 1024);
            int l1 = 0;
            if (Open(DeviceId, ref l1))
                textBox4.Text = Marshal.PtrToStringUni(DeviceId);
            else
                MessageBox.Show(GetError());
            Marshal.FreeHGlobal(DeviceId);
        }

        private void Print_btn_Click(object sender, EventArgs e)
        {
            var Xml = Marshal.StringToHGlobalUni(richTextBox2.Text);
            var DeviceId = Marshal.StringToHGlobalUni(textBox4.Text);
            if (PrintLabels(DeviceId, textBox4.Text.Length, Xml, richTextBox2.Text.Length))
                MessageBox.Show("Print successfully!");
            else
                MessageBox.Show(GetError());
            Marshal.FreeHGlobal(DeviceId);
            Marshal.FreeHGlobal(Xml);
        }

        private void OpenDesigner_btn_Click(object sender, EventArgs e)
        {
            var Xml = Marshal.StringToHGlobalUni(richTextBox2.Text);
            var DPI = Marshal.StringToHGlobalUni(textBox2.Text);
            var OutXml = Marshal.AllocHGlobal(1024 * 1024);
            int l1 = 0;
            if (OpenDesigner(Xml, richTextBox2.Text.Length, DPI, textBox2.Text.Length, OutXml, ref l1))
            {
                richTextBox2.Clear();
                richTextBox2.AppendText(Marshal.PtrToStringUni(OutXml));
            }
            Marshal.FreeHGlobal(OutXml);
            Marshal.FreeHGlobal(DPI);
            Marshal.FreeHGlobal(Xml);
        }

        private void Close_btn_Click(object sender, EventArgs e)
        {
            richTextBox1.Clear();
            var DeviceId = Marshal.StringToHGlobalUni(textBox4.Text);
            if (Close(DeviceId, textBox4.Text.Length))
                richTextBox1.AppendText("Printer close!");
            else
                richTextBox1.AppendText(GetError());
            Marshal.FreeHGlobal(DeviceId);
        }

        private void GetTemplateList_btn_Click(object sender, EventArgs e)
        {
            richTextBox1.Clear();
            var TList = Marshal.AllocHGlobal(1024 * 1024);
            int l1 = 0;
            if (GetTemplatesList(TList, ref l1))
                richTextBox1.AppendText(Marshal.PtrToStringUni(TList));
            else
                richTextBox1.AppendText(GetError());
            Marshal.FreeHGlobal(TList);
            
        }

        private void GetActions_btn_Click(object sender, EventArgs e)
        { 
            richTextBox1.Clear();
            var Xml = Marshal.AllocHGlobal(1024 * 1024);
            int l1 = 0;
            if (GetAdditionalActions(Xml, ref l1))
                richTextBox1.AppendText(Marshal.PtrToStringUni(Xml));
            else
                richTextBox1.AppendText(GetError());
            Marshal.FreeHGlobal(Xml); 
        }

        private void DoActions_btn_Click(object sender, EventArgs e)
        {
            richTextBox1.Clear();
            var AdditionalActionName = Marshal.StringToHGlobalAuto(textBox5.Text);
            DoAdditionalAction(AdditionalActionName, textBox5.Text.Length);
            Marshal.FreeHGlobal(AdditionalActionName);
        }

        private void DeviceTest_btn_Click(object sender, EventArgs e)
        {
            richTextBox1.Clear();
            var Description = Marshal.AllocHGlobal(1024 * 1024);
            var DemoModeDescription = Marshal.AllocHGlobal(1024 * 1024);
            int l1 = 0;
            int l2 = 0;
            if (DeviceTest(Description, ref l1, DemoModeDescription, ref l2))
                richTextBox1.AppendText(Marshal.PtrToStringUni(Description) + "\r\n" + Marshal.PtrToStringUni(DemoModeDescription));
            else
                richTextBox1.AppendText(GetError());
            Marshal.FreeHGlobal(Description);
            Marshal.FreeHGlobal(DemoModeDescription); 
        }

        private void InitPrinter_btn_Click(object sender, EventArgs e)
        {
            richTextBox1.Clear();
            var DeviceId = Marshal.StringToHGlobalAuto(textBox4.Text);
            if (InitializePrinter(DeviceId, textBox4.Text.Length))
                richTextBox1.AppendText("Printer init successfully!");
            else
                richTextBox1.AppendText(GetError());
            Marshal.FreeHGlobal(DeviceId);
        }

        private void GetTemplates_btn_Click(object sender, EventArgs e)
        {
            richTextBox2.Clear();
            var Xml = Marshal.StringToHGlobalAuto(richTextBox1.Text);
            var OutXml = Marshal.AllocHGlobal(1024 * 1024);
            int l1 = 0;
            if (GetTemplates(Xml, richTextBox1.Text.Length, OutXml, ref l1))
                richTextBox2.AppendText(Marshal.PtrToStringUni(OutXml));
            else
                richTextBox2.AppendText(GetError());
            Marshal.FreeHGlobal(Xml);
            Marshal.FreeHGlobal(OutXml); 
        }

        private void SaveTemplate_btn_Click(object sender, EventArgs e)
        {
            richTextBox1.Clear();
            var Xml = Marshal.StringToHGlobalAuto(richTextBox2.Text);
            var Name = Marshal.StringToHGlobalAuto(textBox6.Text);
            var Email = Marshal.StringToHGlobalAuto(textBox7.Text);
            var Answer = Marshal.AllocHGlobal(1024 * 1024);
            int l1 = 0;
            if (SaveTemplate(Xml, richTextBox2.Text.Length, Name, textBox6.Text.Length, Email, textBox7.Text.Length, Answer, ref l1))
                richTextBox1.AppendText(Marshal.PtrToStringUni(Answer));
            else
                richTextBox1.AppendText(GetError());
            Marshal.FreeHGlobal(Xml);
            Marshal.FreeHGlobal(Name);
            Marshal.FreeHGlobal(Email);
            Marshal.FreeHGlobal(Answer); 
        }

        private void GetError_btn_Click(object sender, EventArgs e)
        {
            richTextBox1.Clear();
            richTextBox1.AppendText(GetError());
        }

        private void Init_btn_Click(object sender, EventArgs e)
        {
            richTextBox1.Clear();
            var Locale = Marshal.StringToHGlobalUni(textBox8.Text);
            Init(Locale, textBox8.Text.Length);
            richTextBox1.AppendText("Init done!");
            Marshal.FreeHGlobal(Locale);
            Init_btn.Enabled = false;
            GetVersion_btn.Enabled = true;
            GetParametrs_btn.Enabled = true;
            SetParametrs_btn.Enabled = true;
            Open_btn.Enabled = true;
            Print_btn.Enabled = true;
            OpenDesigner_btn.Enabled = true;
            Close_btn.Enabled = true;
            GetTemplateList_btn.Enabled = true;
            GetActions_btn.Enabled = true;
            DoActions_btn.Enabled = true;
            DeviceTest_btn.Enabled = true;
            InitPrinter_btn.Enabled = true;
            GetTemplates_btn.Enabled = true;
            SaveTemplate_btn.Enabled = true;
            GetError_btn.Enabled = true;
            Done_btn.Enabled = true;
        }

        private void Done_btn_Click(object sender, EventArgs e)
        {
            Done();
            richTextBox1.Clear();
            richTextBox1.AppendText("DLL close!");

            Init_btn.Enabled = true;
            GetVersion_btn.Enabled = false;
            GetParametrs_btn.Enabled = false;
            SetParametrs_btn.Enabled = false;
            Open_btn.Enabled = false;
            Print_btn.Enabled = false;
            OpenDesigner_btn.Enabled = false;
            Close_btn.Enabled = false;
            GetTemplateList_btn.Enabled = false;
            GetActions_btn.Enabled = false;
            DoActions_btn.Enabled = false;
            DeviceTest_btn.Enabled = false;
            InitPrinter_btn.Enabled = false;
            GetTemplates_btn.Enabled = false;
            SaveTemplate_btn.Enabled = false;
            GetError_btn.Enabled = false;
            Done_btn.Enabled = false;
        }   
    } 
}
