#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "dllexport.h"
#include "stdlib.h"

MainWindow::MainWindow(QWidget *parent) : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);
}

MainWindow::~MainWindow()
{
    if (ui->Done_btn_18->isEnabled())
        Done();

    delete ui;
}

void MainWindow::on_Init_btn_clicked()
{
    int LocaleLength = ui->lineEdit_8->text().length() + 1;
    wchar_t *Locale = (wchar_t *)malloc(LocaleLength * sizeof(wchar_t));
    ui->lineEdit_8->text().toWCharArray(Locale);
    Init(Locale, LocaleLength - 1);
    ui->plainTextEdit->setPlainText(QString::fromWCharArray(Locale, LocaleLength - 1));
    free(Locale);

    ui->Init_btn->setEnabled(false);
    ui->GetVersion_btn->setEnabled(true);
    ui->GetParametrs_btn->setEnabled(true);
    ui->SetParametrs_btn->setEnabled(true);
    ui->Open_btn->setEnabled(true);
    ui->Close_btn->setEnabled(true);
    ui->DeviceTest_btn->setEnabled(true);
    ui->GetAdditionalActions_btn->setEnabled(true);
    ui->DoAdditionalAction_btn->setEnabled(true);
    ui->InitPrinter_btn->setEnabled(true);
    ui->Print_btn->setEnabled(true);
    ui->OpenDesigner_btn->setEnabled(true);
    ui->GetTemplatesList_btn->setEnabled(true);
    ui->GetTemplates_btn->setEnabled(true);
    ui->SaveTemplate_btn->setEnabled(true);
    ui->GetError_btn->setEnabled(true);
    ui->Done_btn_18->setEnabled(true);
}

void MainWindow::on_GetVersion_btn_clicked()
{
    wchar_t *Version = (wchar_t *)malloc(100);
    int l1;
    Get_Version(Version, &l1);
    ui->plainTextEdit->setPlainText(QString::fromWCharArray(Version, l1));
    free(Version);
}

void MainWindow::on_GetParametrs_btn_clicked()
{
    wchar_t *Xml = (wchar_t *)malloc(1024 * 1024);
    int l1;
    GetParametrs(Xml, &l1);
    ui->plainTextEdit->setPlainText(QString::fromWCharArray(Xml, l1));
    free(Xml);
}

void MainWindow::on_SetParametrs_btn_clicked()
{
    int NameLength = ui->label->text().length() + 1;
    int DPILength = ui->label_2->text().length() + 1;
    int LanguageLength = ui->label_3->text().length() + 1;
    int NameVLength = ui->lineEdit->text().length() + 1;
    int DPIVLength = ui->lineEdit_2->text().length() + 1;
    int LanguageVLength = ui->lineEdit_3->text().length() + 1;

    wchar_t *Name = (wchar_t *)malloc(NameLength * sizeof(wchar_t));
    wchar_t *NameV = (wchar_t *)malloc(NameVLength * sizeof(wchar_t));
    wchar_t *DPI = (wchar_t *)malloc(DPILength * sizeof(wchar_t));
    wchar_t *DPIV = (wchar_t *)malloc(DPIVLength * sizeof(wchar_t));
    wchar_t *Language = (wchar_t *)malloc(LanguageLength * sizeof(wchar_t));
    wchar_t *LanguageV = (wchar_t *)malloc(LanguageVLength * sizeof(wchar_t));

    ui->label->text().toWCharArray(Name);
    ui->lineEdit->text().toWCharArray(NameV);

    QString result = "Successfully set parameter PrinterName";
    if (!SetStringParameter(Name, NameLength - 1, NameV, NameVLength - 1))
        result = GetLastError();
    ui->plainTextEdit->setPlainText(result);

    ui->label_2->text().toWCharArray(DPI);
    ui->lineEdit_2->text().toWCharArray(DPIV);
    result = "Successfully set parameter DPI";
    if (!SetStringParameter(DPI, DPILength - 1, DPIV, DPIVLength - 1))
        result = GetLastError();
    ui->plainTextEdit->appendPlainText(result);

    ui->label_3->text().toWCharArray(Language);
    ui->lineEdit_3->text().toWCharArray(LanguageV);
    result = "Successfully set parameter PrinterLanguage";
    if (!SetStringParameter(Language, LanguageLength - 1, LanguageV, LanguageVLength - 1))
        result = GetLastError();
    ui->plainTextEdit->appendPlainText(result);
}

void MainWindow::on_Open_btn_clicked()
{
    wchar_t *DeviceId = (wchar_t *)malloc(100);
    int l1;
    if (Open(DeviceId, &l1))
        ui->lineEdit_4->setText(QString::fromWCharArray(DeviceId, l1));
    else
        ui->plainTextEdit->setPlainText(GetLastError());
    free(DeviceId);
}

void MainWindow::on_Close_btn_clicked()
{
    int DeviceIdLength = ui->lineEdit_4->text().length() + 1;
    wchar_t *DeviceId = (wchar_t *)malloc(DeviceIdLength * sizeof(wchar_t));
    ui->lineEdit_4->text().toWCharArray(DeviceId);
    if (Close(DeviceId, DeviceIdLength - 1))
        ui->plainTextEdit->setPlainText("Printer close!");
    else
        ui->plainTextEdit->setPlainText(GetLastError());
}

void MainWindow::on_DeviceTest_btn_clicked()
{
    int DescriptionLength;
    wchar_t *Description = (wchar_t *)malloc(1024 * 1024);
    int DescriptionDemoModeLength;
    wchar_t *DescriptionDemoMode = (wchar_t *)malloc(1024 * 1024);
    if (DeviceTest(Description, &DescriptionLength, DescriptionDemoMode,
                   &DescriptionDemoModeLength)) {
        ui->plainTextEdit->setPlainText(QString::fromWCharArray(Description, DescriptionLength));
        ui->plainTextEdit->appendPlainText(
            QString::fromWCharArray(DescriptionDemoMode, DescriptionDemoModeLength));
    } else
        ui->plainTextEdit->setPlainText(GetLastError());
    free(Description);
    free(DescriptionDemoMode);
}

void MainWindow::on_GetAdditionalActions_btn_clicked()
{
    int XmlLength;
    wchar_t *Xml = (wchar_t *)malloc(1024 * 1024);

    if (GetAdditionalActions(Xml, &XmlLength))
        ui->plainTextEdit->setPlainText(QString::fromWCharArray(Xml, XmlLength));
    else
        ui->plainTextEdit->setPlainText(GetLastError());
    free(Xml);
}

void MainWindow::on_DoAdditionalAction_btn_clicked()
{
    int AdditionalActionNameLength = ui->lineEdit_5->text().length() + 1;
    wchar_t *AdditionalActionName = (wchar_t *)malloc(AdditionalActionNameLength * sizeof(wchar_t));

    ui->lineEdit_5->text().toWCharArray(AdditionalActionName);
    if (!DoAdditionalAction(AdditionalActionName, AdditionalActionNameLength - 1))
        ui->plainTextEdit->setPlainText(GetLastError());
    free(AdditionalActionName);
}

void MainWindow::on_InitPrinter_btn_clicked()
{
    int DeviceIDLength = ui->lineEdit_4->text().length() + 1;
    wchar_t *DeviceID = (wchar_t *)malloc(DeviceIDLength * sizeof(wchar_t));

    if (InitializePrinter(DeviceID, DeviceIDLength - 1))
        ui->plainTextEdit->setPlainText("Printer successfully initialized!");
    else
        ui->plainTextEdit->setPlainText(GetLastError());

    free(DeviceID);
}

void MainWindow::on_Print_btn_clicked()
{
    int DeviceIdLength = ui->lineEdit_4->text().length() + 1;
    wchar_t *DeviceId = (wchar_t *)malloc(DeviceIdLength * sizeof(wchar_t));
    int XmlLength = ui->plainTextEdit_2->toPlainText().length() + 1;
    wchar_t *Xml = (wchar_t *)malloc(XmlLength * sizeof(wchar_t));

    ui->lineEdit_4->text().toWCharArray(DeviceId);
    ui->plainTextEdit_2->toPlainText().toWCharArray(Xml);
    if (PrintLabels(DeviceId, DeviceIdLength - 1, Xml, XmlLength - 1))
        ui->plainTextEdit->setPlainText("Printing finished!");
    else
        ui->plainTextEdit->setPlainText(GetLastError());
    free(DeviceId);
    free(Xml);
}

void MainWindow::on_OpenDesigner_btn_clicked()
{
    int XmlLength = ui->plainTextEdit_2->toPlainText().length() + 1;
    wchar_t *Xml = (wchar_t *)malloc(XmlLength * sizeof(wchar_t));

    int ImageDPILength = ui->lineEdit_2->text().length() + 1;
    wchar_t *ImageDPI = (wchar_t *)malloc(ImageDPILength * sizeof(wchar_t));

    int OutXmlLength;
    wchar_t *OutXml = (wchar_t *)malloc(1024 * 1024);

    ui->lineEdit_2->text().toWCharArray(ImageDPI);
    ui->plainTextEdit_2->toPlainText().toWCharArray(Xml);
    if (OpenDesigner(Xml, XmlLength - 1, ImageDPI, ImageDPILength - 1, OutXml, &OutXmlLength))
        ui->plainTextEdit_2->setPlainText(QString::fromWCharArray(OutXml, OutXmlLength));
    else
        ui->plainTextEdit->setPlainText(GetLastError());
    free(ImageDPI);
    free(Xml);
    free(OutXml);
}

void MainWindow::on_GetTemplatesList_btn_clicked()
{
    int XmlLength;
    wchar_t *Xml = (wchar_t *)malloc(1024 * 1024);

    if (GetTemplatesList(Xml, &XmlLength))
        ui->plainTextEdit->setPlainText(QString::fromWCharArray(Xml, XmlLength));
    else
        ui->plainTextEdit->setPlainText(GetLastError());
    free(Xml);
}

void MainWindow::on_GetTemplates_btn_clicked()
{
    int XmlLength = ui->plainTextEdit->toPlainText().length() + 1;
    wchar_t *Xml = (wchar_t *)malloc(XmlLength * sizeof(wchar_t));

    int OutXmlLength;
    wchar_t *OutXml = (wchar_t *)malloc(1024 * 1024);

    ui->plainTextEdit->toPlainText().toWCharArray(Xml);
    if (GetTemplates(Xml, XmlLength - 1, OutXml, &OutXmlLength))
        ui->plainTextEdit_2->setPlainText(QString::fromWCharArray(OutXml, OutXmlLength));
    else
        ui->plainTextEdit->setPlainText(GetLastError());
    free(Xml);
    free(OutXml);
}

void MainWindow::on_SaveTemplate_btn_clicked()
{
    int XmlLength = ui->plainTextEdit_2->toPlainText().length() + 1;
    wchar_t *Xml = (wchar_t *)malloc(XmlLength * sizeof(wchar_t));

    int NameLength = ui->lineEdit_6->text().length() + 1;
    wchar_t *Name = (wchar_t *)malloc(NameLength * sizeof(wchar_t));

    int EmailLength = ui->lineEdit_7->text().length() + 1;
    wchar_t *Email = (wchar_t *)malloc(EmailLength * sizeof(wchar_t));

    int AnswerlLength;
    wchar_t *Answer = (wchar_t *)malloc(1024 * 1024);

    ui->lineEdit_6->text().toWCharArray(Name);
    ui->lineEdit_7->text().toWCharArray(Email);
    ui->plainTextEdit_2->toPlainText().toWCharArray(Xml);
    if (SaveTemplate(Xml, XmlLength - 1, Name, NameLength, Email, EmailLength, Answer,
                     &AnswerlLength))
        ui->plainTextEdit->setPlainText(QString::fromWCharArray(Answer, AnswerlLength));
    else
        ui->plainTextEdit->setPlainText(GetLastError());
    free(Xml);
    free(Name);
    free(Email);
    free(Answer);
}

void MainWindow::on_GetError_btn_clicked()
{
    ui->plainTextEdit->setPlainText(GetLastError());
}

void MainWindow::on_Done_btn_18_clicked()
{
    Done();

    ui->Init_btn->setEnabled(true);
    ui->GetVersion_btn->setEnabled(false);
    ui->GetParametrs_btn->setEnabled(false);
    ui->SetParametrs_btn->setEnabled(false);
    ui->Open_btn->setEnabled(false);
    ui->Close_btn->setEnabled(false);
    ui->DeviceTest_btn->setEnabled(false);
    ui->GetAdditionalActions_btn->setEnabled(false);
    ui->DoAdditionalAction_btn->setEnabled(false);
    ui->InitPrinter_btn->setEnabled(false);
    ui->Print_btn->setEnabled(false);
    ui->OpenDesigner_btn->setEnabled(false);
    ui->GetTemplatesList_btn->setEnabled(false);
    ui->GetTemplates_btn->setEnabled(false);
    ui->SaveTemplate_btn->setEnabled(false);
    ui->GetError_btn->setEnabled(false);
    ui->Done_btn_18->setEnabled(false);
}

QString MainWindow::GetLastError()
{
    wchar_t *Error = (wchar_t *)malloc(1024 * 1024);
    int l1;
    Get_Last_Error(Error, &l1);
    return QString::fromWCharArray(Error, l1);
    free(Error);
}
