#ifndef DLLEXPORTFORCPP_H
#define DLLEXPORTFORCPP_H

// clang-format off
#ifdef WIN
    #ifdef HEXAGONLABELPRINTERDRIVER_LIBRARY
        #define HEXAGONEXPORT_API __declspec(dllexport)
    #else
        #define HEXAGONEXPORT_API __declspec(dllimport)
    #endif
#endif
#ifdef LIN
    #define HEXAGONEXPORT_API
#endif
// clang-format on

extern "C" {

HEXAGONEXPORT_API int Init(wchar_t *Locale, int LocaleStringLength);

HEXAGONEXPORT_API int Done();

HEXAGONEXPORT_API int Get_Last_Error(wchar_t *errorString, int *errorStringBufLen);

HEXAGONEXPORT_API int Get_Version(wchar_t *Version, int *VersionStringBufLen);

HEXAGONEXPORT_API int GetParametrs(wchar_t *Xml, int *XmlStringBufLen);

HEXAGONEXPORT_API int SetStringParameter(wchar_t *Name, int NameStringLength, wchar_t *Value,
                                         int ValueStringLength);

HEXAGONEXPORT_API int SetIntParameter(wchar_t *Name, int NameStringLength, int value);

HEXAGONEXPORT_API int Open(wchar_t *DeviceId, int *DeviceIdStringBufLen);

HEXAGONEXPORT_API int Close(wchar_t *DeviceId, int DeviceIdStringLength);

HEXAGONEXPORT_API int DeviceTest(wchar_t *Description, int *DescriptionStringBufLen,
                                 wchar_t *DemoModeDescription,
                                 int *DemoModeDescriptionStringBufLen);

HEXAGONEXPORT_API int GetAdditionalActions(wchar_t *Xml, int *XmlStringBufLen);

HEXAGONEXPORT_API int DoAdditionalAction(wchar_t *AdditionalActionName,
                                         int AdditionalActionNameStringLength);

HEXAGONEXPORT_API int InitializePrinter(wchar_t *DeviceId, int DeviceIdStringLength);

HEXAGONEXPORT_API int PrintLabels(wchar_t *DeviceId, int DeviceIdStringLength, wchar_t *Xml,
                                  int XmlStringLength);

HEXAGONEXPORT_API int OpenDesigner(wchar_t *Xml, int XmlStringLength, wchar_t *ImagesDpi,
                                   int ImagesDpiStringLength, wchar_t *OutXml,
                                   int *OutXmlStringBufLen);

HEXAGONEXPORT_API int GetTemplatesList(wchar_t *OutXml, int *OutXmlStringBufLen);

HEXAGONEXPORT_API int GetTemplates(wchar_t *Xml, int XmlStringLength, wchar_t *OutXml,
                                   int *OutXmlStringBufLen);

HEXAGONEXPORT_API int SaveTemplate(wchar_t *Xml, int XmlStringLength, wchar_t *Name,
                                   int NameStringLength, wchar_t *Email, int EmailStringLength,
                                   wchar_t *Answer, int *AnswerStringBufLen);
}

#endif // DLLEXPORTFORCPP_H
